

   /**
    *  Control the different menu-popups for Thunderbird/Mailapp
    *  for References, Reminders and ICS-attachements
    *  
    *  @param thisId	indicates the 'source' or the id of the menu called from:
<ul>
<br>    'List'   - attachmentListContext  
<br>    'Thread' - threadPaneContext
<br>    'Msg'    - messagePaneContext
</ul>
    */
function rmFxPopupCheck(thisId){
	
	var mailRm_AddReminder = document.getElementById("mailRm_AddReminder");
	var mailRm_Open_Msg = document.getElementById("mailRm_Open_Msg");
	var mailRm_ICS_Msg = document.getElementById("mailRm_ICS_Msg");
	var mailRm_Open_Thread = document.getElementById("mailRm_Open_Thread");
	var mailRm_thread_AddReminder = document.getElementById("mailRm_thread_AddReminder");
	var mailRm_ICS_List = document.getElementById("mailRm_ICS_List");
	var mailRm_addContact = document.getElementById("mailRm_addContact");
	var mailRm_copyContact = document.getElementById("mailRm_copyContact");
	var mailRM_sep1 = document.getElementById("mailRM_sep1");
	var mailRM_sep2 = document.getElementById("mailRM_sep2");
	var mailRM_sep3 = document.getElementById("mailRM_sep3");
	
	
	var contextMenusEnabled = true;			
	try {
		contextMenusEnabled = reminderFox_prefs.getBoolPref(REMINDER_FOX_PREF + "." + REMINDER_FOX_ENABLE_CONTEXT_MENUS);
	} catch(e) {
	}			
	
	// user doesn't want context menus; hide them
	if (!contextMenusEnabled ) {
		if (mailRm_AddReminder != null  )
			mailRm_AddReminder.hidden =true;
		if (mailRm_Open_Msg != null  )
	   	mailRm_Open_Msg.hidden = true;
   	if (mailRm_ICS_Msg != null  )
   		mailRm_ICS_Msg.hidden = true;
   	if (mailRm_Open_Thread != null  )
   		mailRm_Open_Thread.hidden = true;
   	if (mailRm_thread_AddReminder != null  )
   		mailRm_thread_AddReminder.hidden = true;
   	if (mailRm_ICS_List != null  )
   		mailRm_ICS_List.hidden = true;
   	if (mailRm_addContact != null  )
   		mailRm_addContact.hidden = true;
   	if (mailRm_copyContact != null  )
   		mailRm_copyContact.hidden = true;
   	if (mailRM_sep1 != null  )
   		mailRM_sep1.hidden = true;
   	if (mailRM_sep2 != null  )
   		mailRM_sep2.hidden = true;   	   	
   	if (mailRM_sep3 != null  )
   		mailRM_sep3.hidden = true;   	   	   	   		
		return;
	}
	
		if (mailRm_AddReminder != null  )
			mailRm_AddReminder.hidden =false;
		if (mailRm_Open_Msg != null  )
   		mailRm_Open_Msg.hidden = false;
   	if (mailRm_ICS_Msg != null  )
   		mailRm_ICS_Msg.hidden = false;
   	if (mailRm_Open_Thread != null  )
   		mailRm_Open_Thread.hidden = false;
   	if (mailRm_thread_AddReminder != null  )
   		mailRm_thread_AddReminder.hidden = false;
   	if (mailRm_ICS_List != null  )
   		mailRm_ICS_List.hidden = false;
   	if (mailRm_addContact != null  )
   		mailRm_addContact.hidden = false;
   	if (mailRm_copyContact != null  )
   		mailRm_copyContact.hidden = false;
   	if (mailRM_sep1 != null  )
   		mailRM_sep1.hidden = false;
   	if (mailRM_sep2 != null  )
   		mailRM_sep2.hidden = false;   	   	
   	if (mailRM_sep3 != null  )
   		mailRM_sep3.hidden = false;   	   	   	     		   		

	var dMode = true;

	if (thisId.originalTarget.id == "threadPaneContext") 		{ var xulId = "Thread";}
	if (thisId.originalTarget.id == "messagePaneContext") 		{ var xulId = "Msg";}
	if (thisId.originalTarget.id == "attachmentListContext") 	{ var xulId = "List";}

// for TB3/SM2
	if (thisId.originalTarget.id == "mailContext") 				{ var xulId = "Msg";}
 
// for Postbox
	if (thisId.originalTarget.id == "dataPaneAttachmentContextMenu") { var xulId = "List";}
 
	if ((xulId == "Msg") || (xulId == "List") || (xulId == "data")) {
	// ----  check 'attachment(s)' for ICS reminders  ----
	
		if (currentAttachments.length > 0) { 
			var i=0;
			while (i < currentAttachments.length) {	
				var xx =currentAttachments[i].contentType.toLowerCase();	
				if ((xx == "text/calendar") 	/* 'normal apps */					
				 || (xx == "application/ics") /* Google Calendar */ 	
					) {dMode = false;}
		/*
		0001: currentAttachments[1].contentType = [string] "application/octet-stream"
		0001: currentAttachments[1].displayName = [string] "c124447.ics"
		*/
				if ((xx == "application/octet-stream") 
				 && (currentAttachments[i].displayName.toLowerCase().search(".ics")>-1 )) {
					{dMode = false;}
				}					
				i++;
			}		
		}	
		if (dMode == false) {
			document.getElementById("mailRm_ICS_" +xulId).removeAttribute("disabled");
		} else {
			document.getElementById("mailRm_ICS_" +xulId).setAttribute("disabled", "true");			
		}
	}
	
	if ((xulId == "Thread") || (xulId == "Msg")) {
	// ---- check message for 'References' and/or 'reminder.Id'  ---- 		
	
		if (rmFxGetRmRef().length > 0) {
			document.getElementById("mailRm_Open_" +xulId).removeAttribute("disabled");
			rmFx_msgTAGing("Reminderfox", true, "#993399");
		} else {
			document.getElementById("mailRm_Open_" +xulId).setAttribute("disabled", "true");			
		}  									
	}
}

/**
 *  Control the different menu-popups for 'addReminder list'
 *  for Contacts     //gW_Contact
 *  @since TB3/SM2 and it's TB/AB rework
 *  
 *  @param thisId	indicates the 'source' or the id of the menu called from
 */
function rmFxPopupCheckMenus(event){ 
	//need delay for todo/lists for disabling menu item -- to wait the list is loaded
	setTimeout( rmFxPopupCheckMenusDelayed, 300, event );
 }	 
	 
function rmFxPopupCheckMenusDelayed(event) {
	
	var pMode = false;
	document.getElementById("treechildren-contextmenu-reminder-openABcard").setAttribute("hidden", "true");
	document.getElementById("treechildren-contextmenu-todo-openABcard").setAttribute("hidden", "true");
	
	var selectedEvents = null; 
	if (event.originalTarget.id == "treechildren-contextmenu")  {
		selectedEvents = getAllSelectedReminders();	// from 'reminder list' context menu
	}
	if (event.originalTarget.id == "todo-treechildren-contextmenu")  {
		selectedEvents = getAllSelectedTodos();	// from 'reminder list' context menu
	}
	
	if (selectedEvents != null) {
		if (selectedEvents.length == 1 && selectedEvents[0] != null ) {			
			if (selectedEvents[0].extraInfo != null) {
				if (selectedEvents[0].extraInfo.indexOf("X-REMINDERFOX-CONTACT:") != -1) pMode = true;
				if ((pMode == true) && gRmFx_AB3) {
					document.getElementById("treechildren-contextmenu-reminder-openABcard").removeAttribute("hidden");
					document.getElementById("treechildren-contextmenu-todo-openABcard").removeAttribute("hidden");
				}
			}
		}
	}
	
	// ---- for migration of UserLists to ToDo's -----------
   var tabList = document.getElementById("tabList");   
   var tabIndex = tabList.selectedIndex;
	
   if (tabIndex > 1) {
   	  if( document.getElementById("migrateTodos-Separator") != null ) { 
      	document.getElementById("migrateTodos-Separator").removeAttribute("hidden");  
   	  }
   	  if( document.getElementById("migrateTodos-Info")!= null ) { 
      		document.getElementById("migrateTodos-Info").removeAttribute("hidden");
   	  }
   	  if (  document.getElementById("migrateTodos") != null ) {
     	 document.getElementById("migrateTodos").removeAttribute("hidden");
   	   }
   }
}

